define([
    'backbone',
    'Layout',
    'modules/appointments/booked/booked-appointments-list-view',
    'modules/appointments/appointments-radio',
    'spec_helpers/custom-matchers',
],
function(Backbone, Layout, AppointmentsListView, radio, customMatchers) {
    'use strict';

    describe('Booked Appointments List View', function() {
        var view;
        var $view;
        var layout = new Layout();

        var MyItemView;
        var childView;
        var $childView;
        var model;

        layout.render();

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            jasmine.addMatchers(customMatchers);

            view = new AppointmentsListView();

            layout.showChildView('content', view);
            $view = view.$el;

            MyItemView = view.childView;
        });

        it('has the list heading', function() {
            var $headers = $view.find('#booked-appointments-table-list .table-list-head .list-cell-header');
            expect($($headers[0]).text()).toEqual('Date/Time');
            expect($($headers[1]).text()).toEqual('Details');
            expect($($headers[2]).text()).toEqual('Prepare/Join');
        });

        it('has the childViewContainer', function() {
            expect($view.has(view.childViewContainer).length).toEqual(1);
        });

        describe('List Item View', function() {
            beforeEach(function() {
                spyOn(radio, 'trigger');
                model = new Backbone.Model({
                    type: 'VA',
                    appointmentTime: '01/01/2016 00:00:00',
                    timeZone: '-4:00 CDT',
                    facilityName: 'FACILITY A',
                    clinic: {
                        name: 'ABC CLINIC',
                        friendlyName: 'FriendlyName',
                    },
                });

                childView = new MyItemView({
                    model: model,
                });
                layout.showChildView('content', childView);
                $childView = childView.$el;
            });

            it('shows the appointment information in a button', function() {
                var $btn = $childView.find('button');
                var $btnCell;

                expect($btn.find('.list-item-prefix').text()).toEqual('View details for your appointment, ');

                $btnCell = $btn.find('.list-cell:eq(0)');
                expect($btnCell.find('.list-cell-header').text()).toEqual('Date/Time: ');
                expect($btnCell.find('.list-cell-data').text()).toEqual('Friday, 01/01/20160000');

                $btnCell = $btn.find('.list-cell:eq(1)');
                expect($btnCell.find('.list-cell-header').text()).toEqual('Details:');
                expect($btnCell.find('.list-cell-data').text()).toEqualWithNormalizedWhitespace('VA Facility Appointment FriendlyName ABC CLINIC');

                $btnCell = $btn.find('.list-cell:eq(2)');
                expect($btnCell.find('.list-cell-header').text()).toEqual('Prepare/Join:');
                expect($btnCell.find('.list-cell-data').text()).toEqualWithNormalizedWhitespace('Prepare for your appointment');
            });

            it('triggers appointments:appointment:selected on click of button', function() {
                $childView.find('button').trigger('click');
                expect(radio.trigger).toHaveBeenCalledWith('appointments:appointment:selected', model);
            });
        });
    });
}
);
